/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.BookmarkService;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.internal.action.BookmarkDelete;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.TreeItem;

public class BookmarkTreePart
extends TreePart {
    private static final DateFormat DF = new SimpleDateFormat("HH:mm");
    private Map<Date, List<Bookmark>> bookmarks = new HashMap<Date, List<Bookmark>>();
    private String query = null;

    public BookmarkTreePart(final Action action) throws ApplicationException {
        super((List)null, new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (!(context instanceof Bookmark)) {
                    return;
                }
                action.handleAction(context);
            }
        });
        this.addColumn(Application.getI18n().tr("Datum"), "created", new DateFormatter(DF));
        this.addColumn(Application.getI18n().tr("Titel"), "title");
        this.addColumn(Application.getI18n().tr("Notiz"), "comment");
        this.setFormatter(new TreeFormatter(){

            @Override
            public void format(TreeItem item) {
                Object data = item.getData();
                if (data == null) {
                    return;
                }
                if (data instanceof Date) {
                    Date date = (Date)data;
                    item.setText(0, DateUtil.DEFAULT_FORMAT.format(date));
                }
            }
        });
        this.setContextMenu(new BookmarkTreeMenu());
        this.setExpanded(true);
        this.setRememberColWidths(true);
        this.update(null);
    }

    /*
     * WARNING - void declaration
     */
    public void update(String query) throws ApplicationException {
        this.query = query;
        this.removeAll();
        this.bookmarks.clear();
        query = StringUtils.trimToNull((String)query);
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        BookmarkService service = bs.get(BookmarkService.class);
        List<Bookmark> list = query != null ? service.search(query) : service.getBookmarks();
        for (Bookmark b : list) {
            void var8_8;
            Date date = DateUtil.startOfDay(b.getCreated());
            List<Bookmark> list2 = this.bookmarks.get(date);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
                this.bookmarks.put(date, arrayList);
            }
            var8_8.add(b);
        }
        BookmarkComparator c = new BookmarkComparator();
        Collection<List<Bookmark>> days = this.bookmarks.values();
        for (List list3 : days) {
            Collections.sort(list3, c);
        }
        ArrayList<Date> root = new ArrayList<Date>();
        root.addAll(this.bookmarks.keySet());
        Collections.sort(root, new Comparator<Date>(){

            @Override
            public int compare(Date d1, Date d2) {
                return d2.compareTo(d1);
            }
        });
        this.setList(root);
    }

    @Override
    protected List getChildren(Object o) {
        if (!(o instanceof Date)) {
            return null;
        }
        return this.bookmarks.get(o);
    }

    private class BookmarkTreeMenu
    extends ContextMenu {
        public BookmarkTreeMenu() {
            this.addItem(new BookmarkMenuItem(Application.getI18n().tr("\u00d6ffnen"), BookmarkTreePart.this.action, "document-open.png"));
            this.addItem(new BookmarkMenuItem(Application.getI18n().tr("L\u00f6schen..."), new BookmarkDelete(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    try {
                        super.handleAction(context);
                        BookmarkTreePart.this.update(BookmarkTreePart.this.query);
                    }
                    catch (OperationCanceledException oce) {
                        Logger.debug((String)"operation cancelled");
                    }
                }
            }, "user-trash-full.png"));
        }

        private class BookmarkMenuItem
        extends CheckedSingleContextMenuItem {
            public BookmarkMenuItem(String text, Action action, String icon) {
                super(text, action, icon);
            }

            @Override
            public boolean isEnabledFor(Object o) {
                return o instanceof Bookmark && super.isEnabledFor(o);
            }
        }
    }

    private class BookmarkComparator
    implements Comparator<Bookmark> {
        private BookmarkComparator() {
        }

        @Override
        public int compare(Bookmark b1, Bookmark b2) {
            return b2.getCreated().compareTo(b1.getCreated());
        }
    }
}

